<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mov_inv_general', function (Blueprint $table) {
            $table->id('idmovinventariogral');
            $table->integer('idsucursal');
            $table->bigInteger('idmovinventariogral_desk');
            $table->bigInteger('idinventariofisicogral')->nullable();
            $table->date('fecha')->nullable();
            $table->bigInteger('idalmacen');
            $table->smallInteger('estatus');
            $table->bigInteger('idconceptoinventario');
            $table->bigInteger('idusuario');
            $table->decimal('costoinventario', 18, 6);
            $table->bigInteger('idalmacendestino');
            $table->integer('idorigeninventario')->nullable();
            $table->string('comentarios', 120);
            $table->string('horamovimiento', 20);
            $table->string('nombre_proveedor', 180)->nullable();
            $table->bigInteger('idturno');
            $table->timestamp('fechahora_registro')->useCurrent();
            $table->string('usuario', 50);
            $table->string('from_host', 50);
            $table->string('origen_movimiento', 50);
            $table->string('tipo_movimiento', 50);
            $table->smallInteger('signo');
            $table->string('origen_registro', 15)->nullable();
            $table->smallInteger('descargado')->nullable();
            $table->bigInteger('idproveedor')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mov_inv_general');
    }
};
