<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mov_inv_existencias', function (Blueprint $table) {
            $table->id('idmovinvexistencia');
            $table->integer('idsucursal');
            $table->bigInteger('idinventario');
            $table->bigInteger('idproducto');
            $table->bigInteger('idalmacen');
            $table->decimal('existencia', 18, 6);
            $table->integer('contados');
            $table->integer('idsucursalorigen');
            $table->string('origen_registro', 15)->nullable();
            $table->smallInteger('descargado');
            $table->decimal('existencia_en_presentaciones', 18, 6)->nullable();
            $table->decimal('existencia_proporcional', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mov_inv_existencias');
    }
};
