<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ing_ventasdetalle', function (Blueprint $table) {
            $table->id('idsaledetail');
            $table->bigInteger('idsucursal');
            $table->bigInteger('idventageneral');
            $table->bigInteger('idproducto');
            $table->bigInteger('idfamilia')->nullable()->default(1);
            $table->string('clave', 30);
            $table->string('descripcion', 1000)->nullable();
            $table->decimal('precio', 18, 6);
            $table->decimal('importe', 18, 6);
            $table->timestamp('fechahora')->useCurrentOnUpdate()->useCurrent();
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->decimal('precionormal', 18, 6);
            $table->decimal('cantidad', 18, 6);
            $table->decimal('cantidaddevueltaxnc', 18, 6)->nullable();
            $table->binary('descripcionadicional')->nullable();
            $table->decimal('costopromedio', 18, 6)->nullable();
            $table->decimal('costo_venta', 18, 6);
            $table->decimal('utilidad', 18, 6);
            $table->string('clave_prodserv', 10)->nullable();
            $table->string('clave_unidadmedida', 10)->nullable();
            $table->string('unidadmedida', 30)->nullable();
            $table->string('clave_impuesto', 10)->nullable();
            $table->string('impuesto', 10)->nullable();
            $table->string('tasa_factor', 20)->nullable();
            $table->string('clave_tipofactor', 10)->nullable();
            $table->string('tasa_impuesto', 20)->nullable();
            $table->string('tasa_tipo_rango', 20)->nullable();
            $table->decimal('tasa_valor_maximo', 18, 6)->nullable();
            $table->smallInteger('tasa_traslado')->nullable();
            $table->smallInteger('tasa_retencion')->nullable();
            $table->decimal('importe_impuesto', 18, 6)->nullable();
            $table->string('ccb_frombascula', 30);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ing_ventasdetalle');
    }
};
