<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cortes_turnos', function (Blueprint $table) {
            $table->id('idturn');
            $table->integer('idsucursal');
            $table->bigInteger('idturno');
            $table->integer('idusuario');
            $table->integer('idcaja_apertura');
            $table->timestamp('fechahora_apertura')->nullable();
            $table->decimal('importe_caja_inicial', 18, 6);
            $table->smallInteger('turno_cerrado');
            $table->integer('idcaja_cierre')->nullable();
            $table->timestamp('fechahora_cierre')->nullable();
            $table->decimal('ing_notasrem', 18, 6)->nullable();
            $table->decimal('ing_facturas', 18, 6)->nullable();
            $table->decimal('ing_cobranza_cxc', 18, 6)->nullable();
            $table->decimal('ing_servicios', 18, 6)->nullable();
            $table->decimal('ing_apartados', 18, 6)->nullable();
            $table->decimal('ing_reparaciones', 18, 6)->nullable();
            $table->decimal('ing_encargos', 18, 6)->nullable();
            $table->decimal('ing_refrendos', 18, 6)->nullable();
            $table->decimal('ing_abonos_capital', 18, 6)->nullable();
            $table->decimal('ing_empenios', 18, 6)->nullable();
            $table->decimal('ing_taller', 18, 6)->nullable();
            $table->decimal('ing_otros_ingresos', 18, 6)->nullable();
            $table->decimal('egr_otros_egresos', 18, 6)->nullable();
            $table->decimal('egr_compras', 18, 6)->nullable();
            $table->decimal('total_billetes', 18, 6)->nullable();
            $table->decimal('total_monedas', 18, 6)->nullable();
            $table->decimal('total_tarjetas_credito', 18, 6)->nullable();
            $table->decimal('total_tarjetas_debito', 18, 6)->nullable();
            $table->decimal('total_corte', 18, 6)->nullable();
            $table->decimal('total_corte_mas_cajai', 18, 6)->nullable();
            $table->decimal('gastos_fijos', 18, 6)->nullable();
            $table->decimal('gastos_pagos_proveedores', 18, 6)->nullable();
            $table->decimal('gastos_consumos', 18, 6)->nullable();
            $table->decimal('gastos_cocina', 18, 6)->nullable();
            $table->decimal('gastos_otros', 18, 6)->nullable();
            $table->boolean('origen_registro')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->decimal('transferencia_electronica', 18, 6)->nullable();
            $table->decimal('vales_electronicos', 18, 6)->nullable();
            $table->decimal('cheques', 18, 6)->nullable();
            $table->decimal('otros', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cortes_turnos');
    }
};
