<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cortes_turnos_detalle', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->bigInteger('idsucursal');
            $table->bigInteger('idturno');
            $table->bigInteger('idturno_desk')->nullable();
            $table->smallInteger('tipo');
            $table->string('descripcion', 60);
            $table->decimal('importe', 18, 6);
            $table->tinyInteger('origen_registro');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cortes_turnos_detalle');
    }
};
