<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cfdi_general01', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->integer('idsucursal');
            $table->bigInteger('idventageneral');
            $table->bigInteger('idventageneral_desk')->nullable();
            $table->string('serie', 25)->nullable();
            $table->integer('folio')->nullable();
            $table->timestamp('fechahora')->nullable();
            $table->string('sello', 800)->nullable();
            $table->string('clave_formadepago', 100)->nullable();
            $table->string('formadepago', 100)->nullable();
            $table->string('nocertificado', 40);
            $table->string('certificado', 800);
            $table->string('condicionesdepago', 254);
            $table->decimal('subtotalantesdesc', 18, 6);
            $table->decimal('porcentajedescto', 18, 6);
            $table->decimal('importedescto', 18, 6);
            $table->string('motivodescuento', 250);
            $table->string('clave_moneda', 10);
            $table->string('moneda', 20);
            $table->decimal('tipocambio', 18, 6)->nullable();
            $table->decimal('subtotaldespuesdesc', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->string('importeletra', 120);
            $table->string('clave_tipocomprobante', 10);
            $table->string('tipocomprobante', 20);
            $table->string('clave_metododepago', 10);
            $table->string('metododepago', 100);
            $table->string('lugar_expedicion', 10);
            $table->string('confirmacion_pac', 10);
            $table->smallInteger('cancelada');
            $table->string('emisorrfc', 15);
            $table->string('emisornombre', 180);
            $table->string('emisor_clave_regfiscal', 10);
            $table->string('emisorregimenfiscal', 180);
            $table->string('emisordomiciliofiscal', 254);
            $table->string('emisorreferencia', 100);
            $table->string('emisormunicipio', 50);
            $table->string('emisorestado', 50);
            $table->string('emisorpais', 50);
            $table->string('emisorcodigopostal', 10);
            $table->bigInteger('receptoridcliente');
            $table->string('receptorrfc', 15);
            $table->string('receptornombre', 180);
            $table->string('receptordomiciliofiscal', 254);
            $table->string('receptorreferencia', 254);
            $table->string('receptormunicipio', 50);
            $table->string('receptorestado', 50);
            $table->string('receptorpais', 50);
            $table->string('receptorcodigopostal', 10);
            $table->string('recept_clave_residfiscal', 10);
            $table->string('recept_residenciafiscal', 50);
            $table->string('rec_numregidtrib', 50);
            $table->string('clave_usocfdi', 10);
            $table->string('usocfdi', 120);
            $table->decimal('totalimpuestoretenido', 18, 6);
            $table->decimal('totalimpuestotrasladado', 18, 6);
            $table->bigInteger('idusuariocancela')->nullable();
            $table->bigInteger('idusuariocancela_desk')->nullable();
            $table->string('nombreusuariocancela', 30)->nullable();
            $table->string('cfdi_version', 10);
            $table->string('cfdi_uuid', 40);
            $table->timestamp('cfdi_fechatimbrado')->nullable();
            $table->string('cfdi_sellocfd', 800);
            $table->string('cfdi_nocertificadosat', 40);
            $table->string('cfdi_sellosat', 800);
            $table->string('cfdi_cadenaoriginal', 2000);
            $table->string('certificado_emisor', 50);
            $table->string('ruta_archivo_xml', 260)->nullable();
            $table->string('observaciones1', 254);
            $table->string('numerocuentapago', 50);
            $table->string('leyendaformapago', 254);
            $table->decimal('totalanticiposamortizacion', 18, 6);
            $table->decimal('totalretencionesreguladas', 18, 6);
            $table->decimal('totalnetoarecibir', 18, 6);
            $table->string('comentarios', 254);
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idturno_desk')->nullable();
            $table->timestamp('fechahora_registro_desk')->nullable();
            $table->integer('idusuario')->nullable();
            $table->integer('idusuario_desk')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->string('observaciones2', 254)->nullable();
            $table->string('ruta_xml_cancelacion', 260)->nullable();
            $table->string('cfdis_relacionados', 200)->nullable();
            $table->tinyInteger('origen_registro')->nullable();
            $table->timestamp('fecha_cancelacion')->nullable();
            $table->string('info_cancelacion', 254)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cfdi_general01');
    }
};
