<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_proveedores', function (Blueprint $table) {
            $table->id('idprovider');
            $table->integer('idsucursal')->nullable();
            $table->integer('idproveedor')->nullable();
            $table->string('clave', 20);
            $table->smallInteger('espersonafisica');
            $table->string('rfc', 20);
            $table->string('curp', 20);
            $table->string('nombrecorto', 30);
            $table->string('nombrecomercial', 120);
            $table->string('nombre', 180);
            $table->string('calle', 30);
            $table->string('noexterior', 20);
            $table->string('nointerior', 20);
            $table->string('cruzamientos', 100);
            $table->string('colonia', 100);
            $table->string('codigopostal', 10);
            $table->string('ciudad', 30);
            $table->string('municipio', 30);
            $table->string('estado', 30);
            $table->string('pais', 30);
            $table->string('referencia', 150);
            $table->string('telefono', 30);
            $table->string('fax', 20);
            $table->string('email', 50);
            $table->string('contacto', 80);
            $table->decimal('limitecredito', 18, 6);
            $table->smallInteger('diasdecredito');
            $table->date('fechaalta')->nullable();
            $table->integer('idsucursalrepl')->nullable();
            $table->string('origen_registro', 15)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_proveedores');
    }
};
