<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_productos', function (Blueprint $table) {
            $table->id('idproduct');
            $table->bigInteger('idproducto');
            $table->bigInteger('idimpuesto');
            $table->bigInteger('idmarca');
            $table->bigInteger('idfamilia');
            $table->bigInteger('idsubfamilia');
            $table->bigInteger('idunidadmedida');
            $table->string('clave', 30)->default('-1');
            $table->string('nombrecorto', 30);
            $table->string('descripcion', 254);
            $table->smallInteger('manejanumeroserie');
            $table->smallInteger('manejainventario');
            $table->smallInteger('esproductocompuesto');
            $table->string('codigodebarras', 30)->default('-1');
            $table->smallInteger('manejacaducidad');
            $table->smallInteger('productoexclusivo');
            $table->smallInteger('productoactivo');
            $table->smallInteger('leerbascula');
            $table->date('fechaalta')->nullable();
            $table->date('fechaultimacompra')->nullable();
            $table->decimal('precioultimacompra', 18, 6);
            $table->decimal('precioventaantesiva', 18, 6);
            $table->decimal('porcentajeutilidad', 18, 6);
            $table->decimal('precioventaconiva', 18, 6);
            $table->decimal('preciocredito', 18, 6);
            $table->decimal('stockminimo', 18, 6);
            $table->smallInteger('esvisibleenventas')->default(-1);
            $table->smallInteger('pormontoocantidad')->default(-1);
            $table->decimal('limiteparamediomayoreo', 18, 6);
            $table->decimal('preciomediomayoreo', 18, 6);
            $table->decimal('limiteparamayoreo', 18, 6);
            $table->decimal('preciomayoreo', 18, 6);
            $table->decimal('porcentajepuntos', 18, 6)->nullable();
            $table->smallInteger('habilitar_pesaje');
            $table->decimal('pesaje', 18, 6);
            $table->smallInteger('maneja_kilataje');
            $table->integer('idkilataje');
            $table->decimal('comision1x100', 18, 6);
            $table->decimal('comision2x100', 18, 6);
            $table->decimal('comision3x100', 18, 6);
            $table->smallInteger('comisiontipo');
            $table->smallInteger('manejainsumos')->nullable();
            $table->smallInteger('obtener_datos_from_cbb')->nullable();
            $table->smallInteger('aplicar_tipodecambio')->nullable();
            $table->decimal('costo_promedio_antesiva', 18, 6)->nullable();
            $table->decimal('costo_promedio_iva', 18, 6)->nullable();
            $table->decimal('costo_promedio_despuesiva', 18, 6)->nullable();
            $table->smallInteger('es_trace')->nullable();
            $table->string('nota1', 400)->nullable();
            $table->string('nota2', 400)->nullable();
            $table->string('nota3', 400)->nullable();
            $table->string('clave_prodserv', 10);
            $table->string('prodserv', 150);
            $table->string('clave_unidadmedida', 10);
            $table->string('unidadmedida', 150);
            $table->string('clave_impuesto', 10);
            $table->string('impuesto', 80);
            $table->string('clave_tipofactor', 10);
            $table->string('tasa_factor', 20);
            $table->string('tasa_impuesto', 20);
            $table->string('tasa_tipo_rango', 10);
            $table->decimal('tasa_valor_maximo', 18, 6);
            $table->smallInteger('tasa_traslado');
            $table->smallInteger('tasa_retencion');
            $table->string('origen_registro', 15)->nullable();
            $table->boolean('esproductobasepresentacion')->nullable();
            $table->string('imagen')->nullable();
            $table->string('traslado_iva_tipo_factor', 20)->nullable();
            $table->decimal('traslado_iva_tasa_cuota', 18, 6)->nullable();
            $table->string('traslado_ieps_tipo_factor', 20)->nullable();
            $table->decimal('traslado_ieps_tasa_cuota', 18, 6)->nullable();
            $table->string('retencion_iva_tipo_factor', 20)->nullable();
            $table->decimal('retencion_iva_tasa_cuota', 18, 6)->nullable();
            $table->string('retencion_isr_tipo_factor', 20)->nullable();
            $table->decimal('retencion_isr_tasa_cuota', 18, 6)->nullable();
            $table->boolean('traslado_iva_exento')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_productos');
    }
};
