<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_impuestos', function (Blueprint $table) {
            $table->bigInteger('idimpuesto')->primary();
            $table->string('clave_impuesto', 10)->nullable();
            $table->string('descripcion', 80);
            $table->string('retencion', 2);
            $table->string('traslado', 2);
            $table->string('local_federal', 20);
            $table->string('entidad_que_aplica', 50)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_impuestos');
    }
};
