<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_formasdepago', function (Blueprint $table) {
            $table->bigInteger('idformadepago')->primary();
            $table->string('clave_formadepago', 10)->nullable();
            $table->string('descripcion', 80);
            $table->string('bancarizado', 10);
            $table->string('numero_operacion', 30)->nullable();
            $table->string('rfc_emisor', 20)->nullable();
            $table->string('cuenta_ordenante', 30)->nullable();
            $table->string('rfc_beneficiario', 20)->nullable();
            $table->string('cuenta_beneficiario', 30)->nullable();
            $table->string('tipo_cadena_pago', 50)->nullable();
            $table->string('banco_emisor', 80)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_formasdepago');
    }
};
