<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_almacenes', function (Blueprint $table) {
            $table->id('idwarehouse');
            $table->integer('idsucursal');
            $table->bigInteger('idalmacen');
            $table->string('clave', 20);
            $table->string('nombre', 50);
            $table->string('comentarios', 254);
            $table->string('tipo_almacen', 30)->nullable();
            $table->tinyInteger('es_de_control_interno')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_almacenes');
    }
};
