<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cajas', function (Blueprint $table) {
            $table->id('idbox');
            $table->bigInteger('idsucursal');
            $table->integer('idcaja');
            $table->string('nombre_caja', 30);
            $table->string('hostname', 30);
            $table->string('direccionip', 20);
            $table->boolean('origen_registro')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cajas');
    }
};
