<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bitacora_existencias', function (Blueprint $table) {
            $table->id('idbinnacle');
            $table->integer('idsucursal');
            $table->bigInteger('idbitacora');
            $table->timestamp('fechahora_registro')->nullable()->useCurrent();
            $table->string('tipo', 20);
            $table->integer('signo');
            $table->string('usuario', 50)->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->bigInteger('origen_idmovimiento');
            $table->bigInteger('origen_folio')->nullable();
            $table->bigInteger('idproducto');
            $table->decimal('existencia_anterior', 18, 6);
            $table->decimal('movimiento_cantidad', 18, 6);
            $table->decimal('existencia_final', 18, 6);
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idalmacen')->nullable()->default(0);
            $table->string('comentarios', 120);
            $table->decimal('fisico', 18, 6)->nullable();
            $table->decimal('faltante', 18, 6)->nullable();
            $table->decimal('excedente', 18, 6)->nullable();
            $table->decimal('precio_unitario', 18, 6)->nullable();
            $table->decimal('importe', 18, 6)->nullable();
            $table->string('origen_registro', 15)->nullable();
            $table->smallInteger('descargado');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bitacora_existencias');
    }
};
