<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Producto>
 */
class ProductoFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'idfamilia' => 1,
            'idmarca' => 1,
            'clave' => $this->faker->bothify('PROD-###'),
            'imagen' => null,
            'clave_unidadmedida' => $this->faker->bothify('UM-##'),
            'unidadmedida' => $this->faker->randomElement(['Pieza', 'Caja', 'Litro']),
            'clave_prodserv' => $this->faker->bothify('0101####'),
            'prodserv' => $this->faker->word(),
            'habilitar_pesaje' => $this->faker->boolean(),
            'pesaje' => $this->faker->randomFloat(2, 0, 100),
            'manejacaducidad' => $this->faker->boolean(),
            'productoactivo' => 1,
            'leerbascula' => $this->faker->boolean(),
            'productoexclusivo' => $this->faker->boolean(),
            'manejanumeroserie' => $this->faker->boolean(),
            'manejainventario' => $this->faker->boolean(),
            'esvisibleenventas' => $this->faker->boolean(),
            'obtener_datos_from_cbb' => $this->faker->boolean(),
            'aplicar_tipodecambio' => $this->faker->boolean(),
            'esproductocompuesto' => $this->faker->boolean(),
            'manejainsumos' => $this->faker->boolean(),
            'nombrecorto' => $this->faker->word(),
            'descripcion' => $this->faker->sentence(),
            'precioultimacompra' => $this->faker->randomFloat(2, 10, 1000),
            'traslado_iva_tipo_factor' => 'IVA',
            'traslado_iva_tasa_cuota' => $this->faker->randomFloat(6, 0, 0.16),
            'traslado_iva_exento' => $this->faker->boolean(),
            'traslado_ieps_tipo_factor' => 'IEPS',
            'traslado_ieps_tasa_cuota' => $this->faker->randomFloat(6, 0, 0.08),
            'fechaultimacompra' => $this->faker->date(),
            'retencion_iva_tipo_factor' => 'IVA',
            'retencion_iva_tasa_cuota' => $this->faker->randomFloat(6, 0, 0.16),
            'retencion_isr_tipo_factor' => 'ISR',
            'retencion_isr_tasa_cuota' => $this->faker->randomFloat(6, 0, 0.10),
            'costo_promedio_antesiva' => $this->faker->randomFloat(2, 10, 1000),
            'costo_promedio_iva' => $this->faker->randomFloat(2, 1, 160),
            'costo_promedio_despuesiva' => $this->faker->randomFloat(2, 10, 1200),
            'precioventaantesiva' => $this->faker->randomFloat(2, 10, 1000),
            'porcentajeutilidad' => $this->faker->randomFloat(2, 0, 100),
            'precioventaconiva' => $this->faker->randomFloat(2, 10, 1200),
            'nota1' => $this->faker->optional()->sentence(),
            'nota2' => $this->faker->optional()->sentence(),
            'nota3' => $this->faker->optional()->sentence(),
            'fechaalta' => $this->faker->date(),
            'stockminimo' => $this->faker->randomFloat(2, 0, 100),
            'comision1x100' => $this->faker->randomFloat(2, 0, 10),
            'comision2x100' => $this->faker->randomFloat(2, 0, 10),
            'comision3x100' => $this->faker->randomFloat(2, 0, 10),
            'codigodebarras' => $this->faker->ean13(),
            'idempresa' => 1,
            'idproducto' => $this->faker->numberBetween(1000, 9999),
            'comisiontipo' => $this->faker->numberBetween(1, 3),
            'idimpuesto' => $this->faker->numberBetween(1, 5),
            'idsubfamilia' => $this->faker->numberBetween(1, 10),
            'idunidadmedida' => $this->faker->numberBetween(1, 5),
            'preciocredito' => $this->faker->randomFloat(2, 10, 1000),
            'pormontoocantidad' => $this->faker->numberBetween(0, 1),
            'limiteparamediomayoreo' => $this->faker->randomFloat(2, 0, 100),
            'preciomayoreo' => $this->faker->randomFloat(2, 10, 1000),
            'limiteparamayoreo' => $this->faker->randomFloat(2, 0, 100),
            'preciomediomayoreo' => $this->faker->randomFloat(2, 10, 1000),
            'maneja_kilataje' => $this->faker->boolean(),
            'idkilataje' => $this->faker->numberBetween(1, 10),
            'clave_impuesto' => $this->faker->bothify('00#'),
            'impuesto' => $this->faker->randomElement(['IVA', 'IEPS']),
            'clave_tipofactor' => $this->faker->randomElement(['Tasa', 'Cuota']),
            'tasa_factor' => $this->faker->randomElement(['Tasa', 'Cuota']),
            'tasa_impuesto' => $this->faker->randomElement(['IVA', 'IEPS']),
            'tasa_tipo_rango' => $this->faker->randomElement(['Fijo', 'Variable']),
            'tasa_valor_maximo' => $this->faker->randomFloat(6, 0, 0.16),
            'tasa_traslado' => $this->faker->numberBetween(0, 1),
            'tasa_retencion' => $this->faker->numberBetween(0, 1),
            'esproductobasepresentacion' => $this->faker->boolean(),
        ];
    }
}
