<?php

namespace App\Traits;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

trait WithFormRequest
{
    protected function validateWith(string $requestClass, array $data)
    {
        $request = new $requestClass;
        
        $validator = Validator::make($data, $request->rules(), $request->messages(), $request->attributes());
        
        if ($validator->fails()) {
            throw new ValidationException($validator);
        }
        
        return $validator->validated();
    }
}
