<?php

namespace App\Traits;

use App\Enums\AlertOption;
use Livewire\Component;

trait SweetAlert2
{
    protected function alert(array $options, array $events = []): void
    {
        $options = json_encode($options);
        $events = json_encode($events);
        $callbacks = json_encode(AlertOption::callbacks());

        $js = <<<JS
            const options = {$options}

            for (const option in options) {
                if (!{$callbacks}.includes(option)) {
                    continue
                }

                options[option] = eval(options[option])
            }

            const alert = await Swal.fire(options)
            
            if (alert.isConfirmed && {$events}.hasOwnProperty('isConfirmed')) {
                \$wire.call({$events}.isConfirmed.action, {
                    ...{$events}.isConfirmed.data || {},
                    value: alert.value
                })
            }
            
            if (alert.isDenied && {$events}.hasOwnProperty('isDenied')) {
                \$wire.call({$events}.isDenied.action, {
                    ...{$events}.isDenied.data || {},
                    value: alert.value
                })
            }

            if (alert.isDismissed && {$events}.hasOwnProperty('isDismissed')) {
                \$wire.call({$events}.isDismissed.action, {
                    ...{$events}.isDismissed.data || {},
                    value: alert.value
                })
            }
        JS;

        $this->component->js($js);

    }
}
