<?php

namespace App\Traits;

trait ResetNested
{
    public function resetNested($propertyPath, $value = null)
    {
        // Divide la ruta por puntos (ej: product.ultimacompra_con_imp)
        $keys = explode('.', $propertyPath);

        // Apunta al objeto raíz del componente (usualmente $this)
        $target = &$this;

        // Recorre las claves menos la última (para obtener referencia)
        foreach (array_slice($keys, 0, -1) as $key) {
            // Avanza al siguiente nivel del array u objeto
            $target = &$target->$key;
        }

        // Establece el valor
        $target[$keys[count($keys) - 1]] = $value;
    }

    public function resetNestedMultiple(mixed $value = null, array|string ...$propertyPaths)
    {
        $propKey = isset($propertyPaths['propertyPaths']) ? 'propertyPaths' : 0;
        // Si se pasó un solo array como primer argumento
        if (count($propertyPaths) === 1 && is_array($propertyPaths[$propKey])) {
            $propertyPaths = $propertyPaths[$propKey];
        }

        foreach ($propertyPaths as $propertyPath) {
            $keys = explode('.', $propertyPath);
            $target = &$this;

            foreach (array_slice($keys, 0, -1) as $key) {
                if (is_object($target)) {
                    $target = &$target->$key;
                } elseif (is_array($target)) {
                    $target = &$target[$key];
                }
            }

            $lastKey = $keys[count($keys) - 1];

            if (is_object($target)) {
                $target->$lastKey = $value;
            } elseif (is_array($target)) {
                $target[$lastKey] = $value;
            }
        }
    }
}
