<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UsuarioNubeEscritorio extends Model
{
    protected $table = 'usuarios_nube_escritorio';

    protected $fillable = [
        'central_user_id',
        'id_cat_usuarios',
        'activo',
        'idsucursal'
    ];

    public static function puedeCambiarSucursal($centralUserId, $sucursalId)
    {
        return self::where('central_user_id', $centralUserId)
            ->where('idsucursal', $sucursalId)
            ->where('activo', true)
            ->exists();
    }

    public static function obtenerSucursalesPermitidas($centralUserId)
    {
        return self::where('central_user_id', $centralUserId)
            ->where('activo', true)
            ->pluck('idsucursal')
            ->toArray();
    }

    public static function obtenerUsuarioPorSucursal($centralUserId, $sucursalId)
    {
        return self::where('central_user_id', $centralUserId)
            ->where('idsucursal', $sucursalId)
            ->where('activo', true)
            ->first();
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class, 'idsucursal', 'idbranchoffice');
    }

    public function usuarioCat()
    {
        return $this->belongsTo(Usuario::class, 'id_cat_usuarios', 'iduser');
    }
}
