<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Producto extends Model
{
    use hasFactory;

    protected $table = 'cat_productos';

    protected $primaryKey = 'idproduct';

    //Como en la tabla no tiene los 'created_at', 'updated_at' que viene por defecto en laravel se tiene que desactivar
    public $timestamps = false;

    protected $casts = [
        'habilitar_pesaje' => 'boolean',
        'manejacaducidad' => 'boolean',
        'productoactivo' => 'boolean',
        'leerbascula' => 'boolean',
        'productoexclusivo' => 'boolean',
        'manejanumeroserie' => 'boolean',
        'manejainventario' => 'boolean',
        'esvisibleenventas' => 'boolean',
        'obtener_datos_from_cbb' => 'boolean',
        'aplicar_tipodecambio' => 'boolean',
        'esproductocompuesto' => 'boolean',
        'manejainsumos' => 'boolean',
        'productoactivo' => 'boolean',
        'traslado_iva_exento' => 'boolean'
    ];

    protected $attributes = [
        'traslado_iva_tipo_factor' => 'IVA',
        'traslado_ieps_tipo_factor' => 'IEPS',
        'retencion_iva_tipo_factor' => 'IVA',
        'retencion_isr_tipo_factor' => 'ISR',
        //DESECHABLES
        'idimpuesto' => 1,
        'idsubfamilia' => -2,
        'idunidadmedida' => -2,
        'manejanumeroserie' => 0,
        'preciocredito' => 0,
        'pormontoocantidad' => 0,
        'limiteparamediomayoreo' => 0,
        'limiteparamayoreo' => 0,
        'preciomediomayoreo' => 0,
        'preciomayoreo' => 0,
        'limiteparamayoreo' => 0,
        'maneja_kilataje' => 0,
        'idkilataje' => -1,
        'clave_impuesto' => 'a',
        'impuesto' => '12',
        'clave_tipofactor' => '',
        'tasa_factor' => '',
        'tasa_impuesto' => '',
        'tasa_tipo_rango' => '',
        'tasa_valor_maximo' => 0,
        'tasa_traslado' => 0,
        'tasa_retencion' => 0,
        'esproductobasepresentacion' => 0
    ];

    protected $fillable = [
        'idfamilia',
        'idmarca',
        'clave',
        'imagen',
        'clave_unidadmedida',
        'unidadmedida',
        'clave_prodserv',
        'prodserv',
        'habilitar_pesaje',
        'pesaje',
        'manejacaducidad',
        'productoactivo',
        'leerbascula',
        'productoexclusivo',
        'manejanumeroserie',
        'manejainventario',
        'esvisibleenventas',
        'obtener_datos_from_cbb',
        'aplicar_tipodecambio',
        'esproductocompuesto',
        'manejainsumos',
        'nombrecorto',
        'descripcion',
        'precioultimacompra',
        'traslado_iva_tipo_factor',
        'traslado_iva_tasa_cuota',
        'traslado_iva_exento',
        'traslado_ieps_tipo_factor',
        'traslado_ieps_tasa_cuota',
        'fechaultimacompra',
        'retencion_iva_tipo_factor',
        'retencion_iva_tasa_cuota',
        'retencion_isr_tipo_factor',
        'retencion_isr_tasa_cuota',
        'costo_promedio_antesiva',
        'costo_promedio_iva',
        'costo_promedio_despuesiva',
        'precioventaantesiva',
        'porcentajeutilidad',
        'precioventaconiva',
        'nota1',
        'nota2',
        'nota3',
        'productoactivo',
        'fechaalta',
        'stockminimo',
        'comision1x100',
        'comision2x100',
        'comision3x100',
        'codigodebarras',
        'idproducto',
        'comisiontipo',

        //DESECHABLES
        'idimpuesto',
        'idsubfamilia',
        'idunidadmedida',
        'manejanumeroserie',
        'preciocredito',
        'pormontoocantidad',
        'limiteparamediomayoreo',
        'preciomayoreo',
        'limiteparamayoreo',
        'preciomediomayoreo',
        'limiteparamayoreo',
        'maneja_kilataje',
        'idkilataje',
        'clave_impuesto',
        'impuesto',
        'clave_tipofactor',
        'tasa_factor',
        'tasa_impuesto',
        'tasa_tipo_rango',
        'tasa_valor_maximo',
        'tasa_traslado',
        'tasa_retencion',
        'esproductobasepresentacion',
    ];

    public function familia()
    {
        return $this->belongsTo(Familia::class, 'idfamilia', 'idfamily');
    }

    public function marca()
    {
        return $this->belongsTo(Marca::class, 'idmarca', 'idbrand');
    }

    public function inventarios()
    {
        return $this->hasMany(MovInvExistencia::class, 'idproducto', 'idproduct');
    }
}
