<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Config extends Model
{
    use HasFactory;

    protected $connection = 'mysql'; // Usar siempre la conexión mysql (base de datos central maprodb)
    protected $table = 'config';
    protected $primaryKey = 'idempresa';
    public $incrementing = false; // Porque idempresa no es auto-increment
    protected $keyType = 'int';
    public $timestamps = false; // Deshabilitar timestamps (created_at, updated_at)
    
    protected $fillable = [
        'idempresa',
        'afectainventarios',
        'habilitarprecio'
    ];

    protected $casts = [
        'idempresa' => 'integer',
        'afectainventarios' => 'integer',
        'habilitarprecio' => 'integer'
    ];
}
