<?php

namespace App\Models;

use App\Enums\ActionOption;
use Illuminate\Database\Eloquent\Model;

class Concepto extends Model
{
    protected $table = 'cat_conceptosinventarios';
    protected $primaryKey = "idinventoryconcept";
    public $timestamps = false;
    protected $fillable = [
        'idconceptoinventario',
        'clave',
        'conceptoinventario',
        'idaccion',
        'signo',
        'editable',
        'origen_registro'
    ];

    public static function getConceptosByIdAccion(int $idAccion)
    {
        if (!$idAccion && ActionOption::tryFrom($idAccion) === null) {
            return [];
        }
        return self::where('idaccion', $idAccion)->get();
    }
}
