<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cliente extends Model
{
    protected $table = 'cat_clientes';
    protected $primaryKey = 'idclient';
    public $timestamps = false;

    protected $fillable = [
        'idempresa',
        'idcliente',
        'clave',
        'espersonafisica',
        'rfc',
        'curp',
        'nombre',
        'calle',
        'cruzamientos',
        'noexterior',
        'nointerior',
        'colonia',
        'referencia',
        'ciudad',
        'municipio',
        'estado',
        'pais',
        'clave_codigopostal',
        'codigopostal',
        'telefono',
        'email',
        'http',
        'contacto',
        'fechaalta',
        'idlistaprecio',
        'diasdecredito',
        'limitedecredito',
        'comentarios',
        'puntosacumulados',
        'tarjetacliente',
        'estatus',
        'imagentarjetacliente',
        'imagenfotografia',
        'identificacion_tarjeta',
        'identificacion_frontal',
        'identificacion_posterior',
        'comprobante_domicilio',
        'nomanejadatosfiscales',
        'formadepago',
        'metodopago',
        'numerocuentapago',
        'tipocliente',
        'comentarios2',
        'aplicar_desctox100',
        'descuento_a_aplicar',
        'regimenfiscal',
        'usocfdi',
        'origen_registro',
    ];

    /**
     * Scope para buscar por un campo específico
     */
    public function scopeSearch($query, $field, $value)
    {
        return $query->where($field, $value);
    }

    /**
     * Scope para buscar en múltiples campos con OR
     */
    public function scopeSearchOr($query, $fields, $value)
    {
        return $query->where(function ($query) use ($fields, $value) {
            foreach ($fields as $field) {
                $query->orWhere($field, 'LIKE', "%{$value}%");
            }
        });
    }

    /**
     * Obtener la dirección completa del cliente
     */
    public function getDireccionCompletaAttribute()
    {
        $direccion = [];
        
        if ($this->calle) {
            $direccion[] = $this->calle;
        }
        
        if ($this->noexterior) {
            $direccion[] = 'No. ' . $this->noexterior;
        }
        
        if ($this->nointerior) {
            $direccion[] = 'Int. ' . $this->nointerior;
        }
        
        if ($this->colonia) {
            $direccion[] = $this->colonia;
        }
        
        if ($this->codigopostal) {
            $direccion[] = 'C.P. ' . $this->codigopostal;
        }
        
        if ($this->ciudad) {
            $direccion[] = $this->ciudad;
        }
        
        if ($this->estado) {
            $direccion[] = $this->estado;
        }
        
        return implode(', ', $direccion);
    }
}
