<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Almacen extends Model
{
    //
    protected $primaryKey = 'idwarehouse';
    protected $table = 'cat_almacenes';

    protected $appends = ['cantidadajuste', 'accion'];

    public function sucursal() {
        return $this->belongsTo(Sucursal::class, 'idsucursal', 'idbranchoffice');
    }

    public function getCantidadajusteAttribute() {
        return 0;
    }

    public function getAccionAttribute() {
        return 'ENTRADA';
    }
}
