<?php

namespace App\Livewire\PuntoDeVenta\PuntoVentas;

use App\Models\Cliente;
use App\Models\Producto;

class PuntoVentasDataHandler
{
    public static function obtenerClientes( $search = '', $mostrarTabla = false)
    {
        if (!$mostrarTabla) {
            return collect([]);
        }

        $query = Cliente::query();
        if (!empty($search)) {
            $query->where(function($subQuery) use ($search) {
                $subQuery->where('nombre', 'like', '%' . $search . '%')
                          ->orWhere('rfc', 'like', '%' . $search . '%')
                          ->orWhere('clave', 'like', '%' . $search . '%');
            });
        }
  
        return $query->orderBy('nombre')->limit(50)->get();
    }

    public static function obtenerProductos( $search = '', $mostrarTabla = false)
    {
        if (!$mostrarTabla) {
            return collect([]);
        }

        $query = Producto::query();
        if (!empty($search)) {
            $query->where(function($subQuery) use ($search) {
                $subQuery->where('clave', 'like', '%' . $search . '%')
                         ->orWhere('descripcion', 'like', '%' . $search . '%')
                         ->orWhere('nombrecorto', 'like', '%' . $search . '%');
            });
        }

        return $query->orderBy('clave')->limit(50)->get();
    }
}
