<?php

namespace App\Livewire\Catalogos\Proveedores;


use Illuminate\Support\Facades\Auth;
use App\Models\Proveedor;
use Livewire\Attributes\Title;
use Livewire\Component;
use Livewire\WithPagination;

#[Title('Proveedores')]
class Index extends Component
{
    use WithPagination;

    public $idEmpresa;
    public $headerValues;
    public $rowsValues;
    public $search = ''; // Texto del buscador
    public $clave, $nombrecorto, $nombrecomercial, $razonsocial, $rfc, $curp, $telefono, $fax, $email, $contacto, $limite_credito, $dias_credito, $tipo_persona;
    public $calle, $cruzamientos, $no_exterior, $no_interior, $colonia, $localidad, $municipio, $estado, $pais, $cp, $referencia;
    public $activeTab = 'general'; // Pestaña activa
    
    public function render()
    {
        $proveedores = Proveedor::search('idempresa', $this->idEmpresa)
            ->searchOr(['clave', 'nombrecorto', 'nombrecomercial', 'nombre', 'idprovider'], $this->search)
            ->orderBy('idprovider', 'asc')
            ->paginate(7);

        return view('livewire.catalogos.proveedores.index', [
            'proveedores' => $proveedores,
        ]);
    }

    public function mount()
    {
        $this->idEmpresa = Auth::user()->idempresa;
        $this->headerValues = [
            'ID Empresa',
            'ID Proveedor',
            'Clave',
            'Nombre Corto',
            'Nombre Comercial',
            'Razón Social',
        ];
    }

    public function updatingsearch()
    {
        $this->resetPage(); // Reinicia la paginación al buscar
    }

    public function create()
    {
        return redirect()->route('d-catalogos-proveedores-create');
    }

    public function edit($proveedorid)
    {
        return redirect()->route('d-catalogos-proveedores-edit', ['proveedor' => $proveedorid]);
    }

    public function delete($proveedorid)
    {
        Proveedor::findOrFail($proveedorid)->delete();
        
    }
}    