<?php

namespace App\Livewire\Catalogos\Familia;

use App\Models\Familia;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;

#[Title('Editando familia')]
class Edit extends Component
{
    public $clave;
    public $familyid;
    public $comentario;
    public $nombrefamilia;
    public $oldFamily;
    public $alerttitle = 'Familia editada';
    public $alerttext = 'Se edito la familia correctamente';

    protected $rules = [
        'clave' => 'required|min:2|max:20',
        'nombrefamilia' => 'required|min:2|max:50',
        'comentario' => 'max:80',
    ];
    public function mount(Familia $family) {
        $this->oldFamily = $family;
        $this->familyid = $family->idfamily;
        $this->clave = $family->clave;
        $this->comentario = $family->comentario;
        $this->nombrefamilia = $family->nombrefamilia;
    }
    public function render()
    {
        return view('livewire.catalogos.familia.form');
    }

    public function save() {
        $this->validate();
        
        $updatedFamily = Familia::findOrFail($this->familyid);
        $updatedFamily->clave = $this->clave;
        $updatedFamily->nombrefamilia = $this->nombrefamilia;
        $updatedFamily->comentario = $this->comentario;

        $updatedFamily->save();
        $this->dispatch('create-alert');

    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-familias');
    }

    public function clear() {
        $this->familyid = $this->oldFamily->idfamily;
        $this->clave = $this->oldFamily->clave;
        $this->comentario = $this->oldFamily->comentario;
        $this->nombrefamilia = $this->oldFamily->nombrefamilia;
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
}
