<?php

namespace App\Livewire\Catalogos\Familia;

use App\Models\Familia;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;

#[Title('Crear Familia')]
class Create extends Component
{
    public $clave = '';
    public $nombrefamilia = '';
    public $comentario = '';
    public $alerttitle = 'Familia creada';
    public $alerttext = 'Se creó la familia correctamente';

    protected $rules = [
        'clave' => 'required|min:2|max:20',
        'nombrefamilia' => 'required|min:2|max:50',
        'comentario' => 'max:80',
    ];

    public function render()
    {
        return view('livewire.catalogos.familia.form');
    }

    public function save() {
        $this->validate();
        $newFamily = Familia::create([
            'clave' => $this->clave,
            'nombrefamilia' => $this->nombrefamilia,
            'comentario' => $this->comentario,
            'idempresa' => Auth::user()->idempresa,
            'cadenapadre' => '',
            'cadenahijo' => '',
            'idfamilia' => 0,
            'esunasubfamilia' => false,
            'idfamiliapadre' => -1,
            'origen_registro' => 'WEB'
        ]);

        $newFamily->idfamilia = $newFamily->idfamily;
        $newFamily->save();
        $this->dispatch('create-alert');

    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-familias');
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
    
    public function clear() {
        $this->reset();
    }
}
