<?php

namespace App\Livewire\Catalogos\Conceptos;

use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\Concepto;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


#[Title('Creando Concepto de Inventario')]
class Create extends Component
{
    public $idempresa = '';
    public $idconceptoinventario = '';
    public $clave = '';
    public $conceptoinventario = '';
    public $idaccion = '';
    public $signo = '';
    public $editable = '';
    public $acciones = [];
    public $alert_title = 'Concepto de inventario creado';
    public $alert_text = 'Se creó el concepto correctamente';

    protected $rules = [
        'clave' => 'required|string|max:255',
        'conceptoinventario' => 'required|string|max:255'
    ];

    public function mount()
    {
        $this->acciones = DB::table('cat_acciones')
            ->orderBy('idaccion')
            ->pluck('accion', 'idaccion')
            ->toArray();
    }
    
    public function render()
    {
        return view('livewire.catalogos.concepto.form');
    }

    public function save() {
        $this->validate();
        $concepto = Concepto::create([
            'idempresa' => Auth::user()->idempresa,
            'clave' => $this->clave,
            'conceptoinventario' => $this->conceptoinventario,
            'idaccion' => $this->idaccion,
            'signo' => 0,
            'editable' => 1,
            'idconceptoinventario' => 0,
        ]);

        if ($this->idaccion == 1 || $this->idaccion == 2) {
            $concepto->signo = 1;
        } elseif ($this->idaccion == 3) {
            $concepto->signo = -1;
        } else {
            $concepto->signo = 0;
        }

        $concepto->idconceptoinventario = $concepto->idinventoryconcept;
        $concepto->save();
        $this->dispatch('create-alert');
      
    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-conceptos');
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
    
    public function clear() {
        $this->reset();
    }
}