<?php

namespace App\Http\Requests\Inventarios;

use Illuminate\Foundation\Http\FormRequest;

class RegistrarMovimientoInventarioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'almacen_id' => 'required|exists:cat_almacenes,idwarehouse',
            'proveedor_id' => 'nullable|exists:cat_proveedores,idprovider',
            'concepto_id' => 'required|exists:cat_conceptosinventarios,idinventoryconcept',
            'partidas' => 'required|array|min:1|max:100',
            'partidas.*.producto_id' => 'required|exists:cat_productos,idproduct',
            'partidas.*.cantidad' => 'required|numeric|min:0.01',
            'partidas.*.precio' => 'required|numeric|min:0',
            'partidas.*.importe' => 'required|numeric|min:0',
            'partidas.*.lote' => 'nullable|string|max:50',
            'partidas.*.fecha_caducidad' => 'required|date|after:yesterday',
            'partidas.*.justificacion' => 'nullable|string|max:255',
            'importe_total' => 'required|numeric|min:0',
            'fecha_movimiento' => 'required|date|before_or_equal:today',
            'tipo_movimiento' => 'required|in:entrada,salida',
        ];
    }
    
    /**
     * Get custom attributes for validator errors.
     */
    public function attributes(): array
    {
        return [
            'almacen_id' => 'almacén',
            'proveedor_id' => 'proveedor',
            'concepto_id' => 'concepto',
            'partidas.*.cantidad' => 'cantidad',
            'partidas.*.precio' => 'precio',
            'partidas.*.fecha_caducidad' => 'fecha de caducidad',
            'importe_total' => 'importe total',
            'fecha_movimiento' => 'fecha del movimiento',
        ];
    }
}
