<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SucursalController extends Controller
{
    public function index(Request $request)
    {

        $sucursales = DB::table('cat_sucursales')
            ->select('idsucursal', 'rfc', 'razon_social', 'direccion_fiscal', 'telefono1', 'email')
            ->where('activo', 1)
            ->get();

        return response()->json([
            'data' => $sucursales,
            'status' => true,
            'message' => 'Consulta exitosa.',
        ], 200);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        // En un sistema tenant, no necesitamos filtrar por idempresa
        $sucursal = DB::table('cat_sucursales')
            ->select('idbranchoffice as id', 'idsucursal', 'rfc', 'razon_social', 'direccion_fiscal', 'telefono1', 'email', 'activo')
            ->where('idbranchoffice', $id)
            ->first();

        if (!$sucursal) {
            return response()->json([
                'data' => null,
                'status' => false,
                'message' => 'Sucursal no encontrada.',
            ], 404);
        }

        return response()->json([
            'data' => $sucursal,
            'status' => true,
            'message' => 'Consulta exitosa.',
        ], 200);
    }
}
