<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CatRuta;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;

class RutasController extends Controller
{
    /**
     * Mostrar todas las rutas del tenant actual
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request): JsonResponse
    {
        try {
            // En sistema tenant, obtenemos todas las rutas disponibles
            // ya que cada tenant tiene su propia base de datos
            $rutas = CatRuta::all();
            
            return response()->json([
                'success' => true,
                'message' => 'Rutas obtenidas exitosamente',
                'data' => $rutas
            ], 200);
            
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error al obtener las rutas',
            ], 500);
        }
    }

    /**
     * Crear una nueva ruta
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function store(Request $request): JsonResponse
    {
        try {
            // Validar los datos de entrada (sin idempresa en sistema tenant)
            $validatedData = $request->validate([
                'nombreruta' => 'required|string|max:20',
                'origen_registro' => 'integer|min:0|max:127'
            ]);

            // Establecer valor por defecto para origen_registro si no se proporciona
            $validatedData['origen_registro'] = $validatedData['origen_registro'] ?? 0;

            // Crear la nueva ruta
            $ruta = CatRuta::create($validatedData);

            return response()->json([
                'success' => true,
                'message' => 'Ruta creada exitosamente',
                'data' => $ruta
            ], 201);

        } catch (ValidationException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error de validación',
                'errors' => $e->errors()
            ], 422);
            
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error al crear la ruta',
            ], 500);
        }
    }
}
