<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;

class ProductoController extends Controller
{
    public function index(Request $request)
    {
        // En sistema tenant, no necesitamos filtrar por idempresa
        $elementosPorPagina = 10;

        $queryProductos = DB::table('cat_productos')
            ->leftJoin('mov_inv_existencias', 'cat_productos.idproduct', '=', 'mov_inv_existencias.idproducto')
            ->select('cat_productos.idproduct', 'cat_productos.idempresa', 'cat_productos.idproducto', 'cat_productos.idimpuesto', 'cat_productos.idmarca',
                'cat_productos.idfamilia', 'cat_productos.idsubfamilia', 'cat_productos.idunidadmedida', 'cat_productos.clave', 'cat_productos.nombrecorto',
                'cat_productos.descripcion', 'cat_productos.manejanumeroserie', 'cat_productos.manejainventario', 'cat_productos.esproductocompuesto',
                'cat_productos.codigodebarras', 'cat_productos.manejacaducidad', 'cat_productos.productoexclusivo', 'cat_productos.productoactivo',
                'cat_productos.leerbascula', 'cat_productos.fechaalta', 'cat_productos.fechaultimacompra', 'cat_productos.precioultimacompra',
                'cat_productos.precioventaantesiva', 'cat_productos.porcentajeutilidad', 'cat_productos.precioventaconiva',
                'cat_productos.preciocredito', 'cat_productos.stockminimo', 'cat_productos.esvisibleenventas', 'cat_productos.pormontoocantidad',
                'cat_productos.limiteparamediomayoreo', 'cat_productos.preciomediomayoreo', 'cat_productos.limiteparamayoreo',
                'cat_productos.preciomayoreo', 'cat_productos.porcentajepuntos', 'cat_productos.habilitar_pesaje', 'cat_productos.pesaje',
                'cat_productos.maneja_kilataje', 'cat_productos.idkilataje', 'cat_productos.comision1x100', 'cat_productos.comision2x100',
                'cat_productos.comision3x100', 'cat_productos.comisiontipo', 'cat_productos.manejainsumos', 'cat_productos.obtener_datos_from_cbb',
                'cat_productos.aplicar_tipodecambio', 'cat_productos.costo_promedio_antesiva', 'cat_productos.costo_promedio_iva',
                'cat_productos.costo_promedio_despuesiva', 'cat_productos.es_trace', 'cat_productos.nota1', 'cat_productos.nota2', 'cat_productos.nota3',
                'cat_productos.clave_prodserv', 'cat_productos.prodserv', 'cat_productos.clave_unidadmedida', 'cat_productos.unidadmedida',
                'cat_productos.clave_impuesto', 'cat_productos.impuesto', 'cat_productos.clave_tipofactor', 'cat_productos.tasa_factor', 'cat_productos.tasa_impuesto',
                'cat_productos.tasa_tipo_rango', 'cat_productos.tasa_valor_maximo', 'cat_productos.tasa_traslado', 'cat_productos.tasa_retencion',
                'cat_productos.origen_registro', 'cat_productos.esproductobasepresentacion',
                'cat_productos.traslado_iva_tipo_factor', 'cat_productos.traslado_iva_tasa_cuota', 'cat_productos.traslado_ieps_tipo_factor',
                'cat_productos.traslado_ieps_tasa_cuota', 'cat_productos.retencion_iva_tipo_factor', 'cat_productos.retencion_iva_tasa_cuota',
                'cat_productos.retencion_isr_tipo_factor', 'cat_productos.retencion_isr_tasa_cuota', 'cat_productos.traslado_iva_exento',
                'mov_inv_existencias.existencia'
                );

        if(isset($request->descripcion))
        {
            $strDescripcion = trim($request->descripcion);
            $queryProductos = $queryProductos->where('cat_productos.descripcion', 'LIKE','%' . $strDescripcion . '%');
                // ->orWhere('cat_productos.clave', 'LIKE','%' . $strDescripcion . '%');
        }

        $elementosPorPagina = isset($request->elementos_por_pagina) ? $request->elementos_por_pagina : 10;

        return response()->json([
            'status' => true,
            'data' => $queryProductos->paginate($elementosPorPagina),
            'message' => 'Lista de productos.',
        ], 200);
    }

    public function buscarUnoSolo(Request $request){

        $strTextoBusqueda = $request->texto_busqueda;

        $queryProductos = $this->obtenerQueryBaseBusquedaProducto();

        $productoEncontrado = null;
        $strCondicionBusqueda = "";
        $queryProductosPorId = $this->obtenerQueryBaseBusquedaProducto();

        // if($strTextoBusqueda > 0){
            // \Log::debug("el valor '$strTextoBusqueda' es entero");
        $productoEncontrado = $queryProductos->where('clave', $strTextoBusqueda)->first();
        // $strCondicionBusqueda = "por id";
        // }

        if($productoEncontrado == null)
        {
            // \Log::debug("el valor '$strTextoBusqueda' es cadena");
            // $strTextoBusqueda = (string) $strTextoBusqueda;
            // \Log::debug("variable: " . $strTextoBusqueda);
            // \Log::debug("tipo de variable: " . gettype($strTextoBusqueda));
            // return $queryProductosPorId->where('idproduct', $strTextoBusqueda)->toSql();
            $productoEncontrado = $queryProductosPorId->where('idproduct', $strTextoBusqueda)->first();
            $strCondicionBusqueda = "por id";

        }else{
            $strCondicionBusqueda = "por clave";
        }

        return response()->json([
            'status' => true,
            'data' => $productoEncontrado,
            'condicion_busqueda' => $strCondicionBusqueda,
            'message' => 'Producto.',
        ], 200);
    }

    /**
     * Obtener productos con existencias disponibles por empresa y sucursal
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function productosConExistencia(Request $request)
    {
        // En sistema tenant, no necesitamos filtrar por idempresa
        $elementosPorPagina = 10;

        // Validar que se proporcione la sucursal
        $request->validate([
            'idsucursal' => 'required|integer'
        ]);

        $queryProductos = DB::table('cat_productos')
            ->leftJoin('mov_inv_existencias', 'cat_productos.idproduct', '=', 'mov_inv_existencias.idproducto')
            ->select('cat_productos.idproduct', 'cat_productos.idempresa', 'cat_productos.idproducto', 'cat_productos.idimpuesto', 'cat_productos.idmarca',
                'cat_productos.idfamilia', 'cat_productos.idsubfamilia', 'cat_productos.idunidadmedida', 'cat_productos.clave', 'cat_productos.nombrecorto',
                'cat_productos.descripcion', 'cat_productos.manejanumeroserie', 'cat_productos.manejainventario', 'cat_productos.esproductocompuesto',
                'cat_productos.codigodebarras', 'cat_productos.manejacaducidad', 'cat_productos.productoexclusivo', 'cat_productos.productoactivo',
                'cat_productos.leerbascula', 'cat_productos.fechaalta', 'cat_productos.fechaultimacompra', 'cat_productos.precioultimacompra',
                'cat_productos.precioventaantesiva', 'cat_productos.porcentajeutilidad', 'cat_productos.precioventaconiva',
                'cat_productos.preciocredito', 'cat_productos.stockminimo', 'cat_productos.esvisibleenventas', 'cat_productos.pormontoocantidad',
                'cat_productos.limiteparamediomayoreo', 'cat_productos.preciomediomayoreo', 'cat_productos.limiteparamayoreo',
                'cat_productos.preciomayoreo', 'cat_productos.porcentajepuntos', 'cat_productos.habilitar_pesaje', 'cat_productos.pesaje',
                'cat_productos.maneja_kilataje', 'cat_productos.idkilataje', 'cat_productos.comision1x100', 'cat_productos.comision2x100',
                'cat_productos.comision3x100', 'cat_productos.comisiontipo', 'cat_productos.manejainsumos', 'cat_productos.obtener_datos_from_cbb',
                'cat_productos.aplicar_tipodecambio', 'cat_productos.costo_promedio_antesiva', 'cat_productos.costo_promedio_iva',
                'cat_productos.costo_promedio_despuesiva', 'cat_productos.es_trace', 'cat_productos.nota1', 'cat_productos.nota2', 'cat_productos.nota3',
                'cat_productos.clave_prodserv', 'cat_productos.prodserv', 'cat_productos.clave_unidadmedida', 'cat_productos.unidadmedida',
                'cat_productos.clave_impuesto', 'cat_productos.impuesto', 'cat_productos.clave_tipofactor', 'cat_productos.tasa_factor', 'cat_productos.tasa_impuesto',
                'cat_productos.tasa_tipo_rango', 'cat_productos.tasa_valor_maximo', 'cat_productos.tasa_traslado', 'cat_productos.tasa_retencion',
                'cat_productos.origen_registro', 'cat_productos.esproductobasepresentacion',
                'cat_productos.traslado_iva_tipo_factor', 'cat_productos.traslado_iva_tasa_cuota', 'cat_productos.traslado_ieps_tipo_factor',
                'cat_productos.traslado_ieps_tasa_cuota', 'cat_productos.retencion_iva_tipo_factor', 'cat_productos.retencion_iva_tasa_cuota',
                'cat_productos.retencion_isr_tipo_factor', 'cat_productos.retencion_isr_tasa_cuota', 'cat_productos.traslado_iva_exento',
                'mov_inv_existencias.existencia'
                )
            ->where('mov_inv_existencias.idsucursal', $request->idsucursal)
            ->where('mov_inv_existencias.existencia', '>', 0)
            ->whereNotNull('mov_inv_existencias.existencia');

        // Filtro opcional por descripción
        if(isset($request->descripcion))
        {
            $strDescripcion = trim($request->descripcion);
            $queryProductos = $queryProductos->where('cat_productos.descripcion', 'LIKE','%' . $strDescripcion . '%');
        }

        $elementosPorPagina = isset($request->elementos_por_pagina) ? $request->elementos_por_pagina : 10;

        try {
            return response()->json([
                'status' => true,
                'data' => $queryProductos->paginate($elementosPorPagina),
                'message' => 'Lista de productos con existencias disponibles.',
            ], 200);
        } catch (ValidationException $e) {
            return response()->json([
                'status' => false,
                'message' => 'Errores de validación',
                'errors' => $e->errors()
            ], 422);
        }
    }

    private function obtenerQueryBaseBusquedaProducto()
    {
        $queryBase = DB::table('cat_productos')
            ->select('idproduct', 'idempresa', 'idproducto', 'idimpuesto', 'idmarca',
                'idfamilia', 'idsubfamilia', 'idunidadmedida', 'clave', 'nombrecorto',
                'descripcion', 'manejanumeroserie', 'manejainventario', 'esproductocompuesto',
                'codigodebarras', 'manejacaducidad', 'productoexclusivo', 'productoactivo',
                'leerbascula', 'fechaalta', 'fechaultimacompra', 'precioultimacompra',
                'precioventaantesiva', 'porcentajeutilidad', 'precioventaconiva',
                'preciocredito', 'stockminimo', 'esvisibleenventas', 'pormontoocantidad',
                'limiteparamediomayoreo', 'preciomediomayoreo', 'limiteparamayoreo',
                'preciomayoreo', 'porcentajepuntos', 'habilitar_pesaje', 'pesaje',
                'maneja_kilataje', 'idkilataje', 'comision1x100', 'comision2x100',
                'comision3x100', 'comisiontipo', 'manejainsumos', 'obtener_datos_from_cbb',
                'aplicar_tipodecambio', 'costo_promedio_antesiva', 'costo_promedio_iva',
                'costo_promedio_despuesiva', 'es_trace', 'nota1', 'nota2', 'nota3',
                'clave_prodserv', 'prodserv', 'clave_unidadmedida', 'unidadmedida',
                'clave_impuesto', 'impuesto', 'clave_tipofactor', 'tasa_factor', 'tasa_impuesto',
                'tasa_tipo_rango', 'tasa_valor_maximo', 'tasa_traslado', 'tasa_retencion',
                'origen_registro', 'esproductobasepresentacion',
                'traslado_iva_tipo_factor', 'traslado_iva_tasa_cuota', 'traslado_ieps_tipo_factor',
                'traslado_ieps_tasa_cuota', 'retencion_iva_tipo_factor', 'retencion_iva_tasa_cuota',
                'retencion_isr_tipo_factor', 'retencion_isr_tasa_cuota', 'traslado_iva_exento');

            return $queryBase;
    }
}
