<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PedidosIntermediosDetalle;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PedidosIntermediosDetalleController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        // En sistema tenant, no necesitamos filtrar por idempresa
        $arrPedidosDetIntermedios = DB::table('pedidos_intermedios_detalle_movil')
        ->where('idsucursal', $request->idsucursal)
        ->get();

        return response()->json([
            'status' => true,
            'data' => $arrPedidosDetIntermedios,
            'message' => 'Consulta exitosa de pedidos_intermedios_detalle_movil.',
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $idPedidoIntermedioDet = DB::table('pedidos_intermedios_detalle_movil')
            ->insertGetId([
                'idsucursal'                         => $request->idsucursal,
                'id_pedido_intermedio_general_movil' => $request->id_pedido_intermedio_general_movil,
                'idproducto'                         => $request->idproducto,
                'clave'                              => $request->clave,
                'descripcion'                        => $request->descripcion,
                'unidadmedida'                       => $request->unidadmedida,
                'cantidad'                           => $request->cantidad,
                'cantidadyaenviada'                  => $request->cantidadyaenviada,
                'cantidadxenviar'                    => $request->cantidadxenviar,
            ]);

        return response()->json([
            'status' => true,
            'id_registro' =>$idPedidoIntermedioDet,
            'message' => 'Registro exitoso de pedidos intermedios detalle.',
        ], 200);
    }

    /**
     * Display the specified resource.
     */
    public function show(PedidosIntermediosDetalle $pedidosIntermediosDetalle)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PedidosIntermediosDetalle $pedidosIntermediosDetalle)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PedidosIntermediosDetalle $pedidosIntermediosDetalle)
    {
        //
    }
}
