<?php

namespace App\Exports\Reportes;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithTitle;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExistenciasPorSucursalesExport implements FromCollection, WithHeadings, WithMapping, WithStyles, WithTitle
{
    protected $productos;
    protected $sucursales;

    public function __construct($productos, $sucursales)
    {
        $this->productos = collect($productos);
        $this->sucursales = $sucursales;
    }

    public function collection()
    {
        return $this->productos;
    }

    public function headings(): array
    {
        $headers = ['Folio', 'Clave', 'Familia', 'Descripción'];
        
        foreach ($this->sucursales as $sucursal) {
            $headers[] = $sucursal->razon_social;
        }
        
        return $headers;
    }

    public function map($producto): array
    {
        $row = [
            $producto->folio_correlativo,
            $producto->clave,
            $producto->familia ?? 'Sin familia',
            $producto->descripcion,
        ];
        
        foreach ($this->sucursales as $sucursal) {
            $existencia = $producto->existencias[$sucursal->idbranchoffice] ?? 0;
            $row[] = number_format($existencia, 0);
        }
        
        return $row;
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => [
                'font' => ['bold' => true],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '4a5568']
                ],
                'font' => ['color' => ['rgb' => 'FFFFFF']]
            ],
        ];
    }

    public function title(): string
    {
        return 'Existencias por Sucursales';
    }
}
