<?php

namespace App\Exports\Productos;

use App\Models\Producto;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ProductoExportExcel implements FromQuery, WithHeadings, WithMapping, WithColumnFormatting
{
    protected $idEmpresa;
    protected $search;
    protected $folio;

    public function __construct(int $idEmpresa, ?string $search)
    {
        $this->idEmpresa = $idEmpresa;
        $this->search = $search;
        $this->folio = 1;
    }

    public function headings(): array
    {
        return [
            'Folio Correlativo',
            'Familia',
            'Marca',
            'Clave',
            'Nombre Corto',
            'Descripción',
            'Maneja Inventario',
            'Es Producto Compuesto',
            'Código de Barras',
            'Producto Activo',
            'Fecha Alta',
            'Fecha Ultima Compra',
            'Precio Ultima compra',
            'Precio Venta Antes de IVA',
            'Precio Venta con IVA',
            'Precio Credito',
            'Stock Mínimo',
            'Es Visible en Ventas',
            'Costo Promedio Antesiva',
            'Costo Promedio con IVA',
            'Costo Promedio Despues de IVA',
            'Nota 1',
            'Nota 2',
            'Nota 3',
            'Clave ProdServ',
            'ProdServ',
            'Clave Unidad de Medida',
            'Unidad de Medida',
            'Clave Impuesto',
            'Impuesto',
            'Clave Tipo Factor',
            'Tasa Factor',
            'Tasa Impuesto',
            'Tasa Tipo Rango',
            'Tasa Valor Maximo',
            'Tasa Traslado',
            'Tasa Retencion',
            'Precio Medio Mayoreo',
            'Limite Para Medio Mayoreo',
            'Precio Mayoreo',
            'Limite Para Mayoreo'
        ];
    }

    public function map($producto): array
    {
        return [
            $this->folio++,
            $producto->familia?->nombrefamilia,
            $producto->marca?->marca,
            $producto->clave,
            $producto->nombrecorto,
            $producto->descripcion,
            $producto->manejainventario == 1 ? 'Sí' : 'No',
            $producto->esproductocompuesto  == 1 ? 'Sí' : 'No',
            (string) $producto->codigodebarras,
            $producto->productoactivo == 1 ? 'Sí' : 'No',
            $producto->fechaalta,
            $producto->fechaultimacompra,
            $producto->precioultimacompra,
            $producto->precioventaantesiva,
            $producto->precioventaconiva,
            $producto->preciocredito,
            $producto->stockminimo,
            $producto->esvisibleenventas == 1 ? 'Sí' : 'No',
            $producto->costo_promedio_antesiva,
            $producto->costo_promedio_iva,
            $producto->costo_promedio_despuesiva,
            $producto->nota1,
            $producto->nota2,
            $producto->nota3,
            $producto->clave_prodserv,
            $producto->prodserv,
            $producto->clave_unidadmedida,
            $producto->unidadmedida,
            $producto->clave_impuesto,
            $producto->impuesto,
            $producto->clave_tipofactor,
            $producto->tasa_factor,
            $producto->tasa_impuesto,
            $producto->tasa_tipo_rango,
            $producto->tasa_valor_maximo,
            $producto->tasa_traslado,
            (string) $producto->tasa_retencion,
            $producto->preciomediomayoreo,
            $producto->limiteparamediomayoreo,
            $producto->preciomayoreo,
            $producto->limiteparamayoreo
        ];
    }

    public function columnFormats(): array
    {
        return [
            'I' => NumberFormat::FORMAT_TEXT,
        ];
    }

    public function query()
    {
        return Producto::query()
            ->with(['familia', 'marca'])
            ->where('idempresa', $this->idEmpresa)
            ->searchOr(['clave'], $this->search);
    }
}
