<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class CortesCajaExport implements FromView, ShouldAutoSize, WithStyles
{
    protected $cortes;
    protected $totales;
    protected $filtros;

    public function __construct($cortes, $totales, $filtros = [])
    {
        $this->cortes = $cortes;
        $this->totales = $totales;
        $this->filtros = $filtros;
    }

    public function view(): View
    {
        return view('exports.cortes-caja', [
            'cortes' => $this->cortes,
            'totales' => $this->totales,
            'filtros' => $this->filtros,
        ]);
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true, 'size' => 14]],
            3 => ['font' => ['bold' => true]],
            4 => ['font' => ['bold' => true], 'fill' => ['fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID, 'startColor' => ['rgb' => 'E2E8F0']]],
        ];
    }
}
