<?php

namespace App\Enums;

enum AlertOption: string {
    case Title = 'title';
    case Icon = 'icon';
    case Text = 'text';
    case Timer = 'timer';
    case ShowConfirmButton = 'showConfirmButton';
    case ShowDenyButton = 'showDenyButton';
    case ShowCancelButton = 'showCancelButton';
    case ConfirmButtonText = 'confirmButtonText';
    case DenyButtonText = 'denyButtonText';
    case CancelButtonText = 'cancelButtonText';
    case DidOpen = 'didOpen';
    case DidClose = 'didClose';

    public function is(self $option): bool {
        return $this === $option;
    }

    public static function values(): array {
        return array_map(
            fn (self $option) => $option->value,
            self::cases()
        );
    }

    public static function callbacks(): array {
        return [
            self::DidOpen,
            self::DidClose
        ];
    }
}