<?php

namespace App\Enums;

enum ActionOption: int
{
    case ENTRADA = 2;
    case SALIDA = 3;
    case TRASPASO = 4;

    public function label(): string
    {
        return match ($this) {
            self::ENTRADA => 'Entrada',
            self::SALIDA => 'Salida',
            self::TRASPASO => 'Traspaso',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::ENTRADA => 'green',
            self::SALIDA => 'red',
            self::TRASPASO => 'blue',
        };
    }

    public static function fromLabel(string $label): ?self
    {
        return match (strtolower($label)) {
            'entrada' => self::ENTRADA,
            'salida' => self::SALIDA,
            'traspaso' => self::TRASPASO,
            default => null,
        };
    }
}