<?php

namespace App\Console\Commands;

use App\Models\CentralUser;
use App\Models\Tenant;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class SetupTenancy extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'setup-tenancy';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Setting up tenancy...');

        $tenants = DB::table('users')->distinct()->pluck('idempresa');
        foreach ($tenants as $tenantId) {
            $tenantName = $tenantId;
            DB::statement("INSERT INTO tenants (id, created_at, updated_at, data) VALUES (?, ?, ?, ?)", [
                $tenantName,
                now()->format('Y-m-d H:i:s'),
                now()->format('Y-m-d H:i:s'),
                json_encode(['updated_at' => now()->format('Y-m-d H:i:s'), 'created_at' => now()->format('Y-m-d H:i:s'), 'tenancy_db_name' => env('DB_TENANT_PREFIX', 'tenant_') . $tenantName])
            ]);

            DB::statement(
                "INSERT INTO domains (domain, tenant_id, created_at, updated_at) VALUES (?, ?, ?, ?)",
                [
                    $tenantName . env('APP_DOMAIN'),
                    $tenantName,
                    now()->format('Y-m-d H:i:s'),
                    now()->format('Y-m-d H:i:s')
                ]
            );
        }
        $this->info('Tenants created successfully');

        $this->info('Migrating users to the central database...');
        DB::statement('SET SESSION sql_mode="NO_ENGINE_SUBSTITUTION"');
        $users = User::all()->map(function ($user) {
            return [
                'id' => $user->id,
                'nombre' => $user->nombre,
                'email' => $user->email,
                'password' => $user->password,
                'created_at' => $user->created_at,
                'remember_token' => $user->remember_token,
                'updated_at' => $user->updated_at,
                'tenant_id' => $user->idempresa,
            ];
        });

        CentralUser::insert($users->toArray());

        $this->info('Users migrated successfully');
    }
}
