<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class SepararDatosEmpresas extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'separar-datos-empresas
{--host= : El host del mysql (ejemplo: 127.0.0.1) }
    {--user= : El usuario de la base de datos.}
{--password= : El password del usuario}
{--port=3306 : El puerto del mysql (ejemplo: 3306)}
{--db= : Base de datos principal donde estan todos los datos}
{--cs : Copiar estructura}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        //public function handle()
        {
            $host = $this->option('host') ?? '127.0.0.1';
            $user = $this->option('user') ?? 'root';
            $pass = $this->option('password') ?? '';
            $mainDb = $this->option('db');
            $copyStructure = $this->option('cs') ?? false;

            $tables = ['cat_tiposdepago', 'usuarios_nube_escritorio', 'cat_usuarios', 'cat_clientes', 'cat_familias', 'cat_conceptosinventarios', 'cat_sucursales', 'cat_almacenes', 'cajas', 'bitacora_existencias', 'cat_marcas', 'cat_productos', 'cat_proveedores', 'cfdi_detalle', 'cfdi_detalle01', 'cfdi_general', 'cfdi_general01', 'comprasgeneral', 'comprasdetalle', 'conceptosingresosegresos', 'cortesdecaja', 'cortes_turnos', 'cortes_turnos_detalle', 'documentosingresosegresos', 'ing_ventasgeneral', 'ing_ventasgeneral01', 'ing_ventasdetalle', 'ing_ventasdetalle01', 'mov_changes', 'mov_inv_general', 'mov_inv_detalle', 'mov_inv_existencias', 'pedidos_general_01', 'pedidos_detalle_01', 'pedidos_intermedios_general_movil', 'pedidos_intermedios_detalle_movil', 'permisos', 'productoscompuestos', 'sqldownloads', 'subidas', 'ventasgeneral', 'ventasdetalle'];
            $generalTables = ['cache', 'cache_locks', 'cat_usocfdi', 'categoria', 'articulo', 'cat_formasdepago', 'cat_estados', 'cat_acciones', 'cat_aduanas', 'cat_unidades', 'cat_codigospostales', 'cat_tiporelacion', 'cat_tipofactor', 'cat_tipocomprobante', 'cat_tasa_o_cuota', 'cat_prodserv', 'cat_regimenfiscal', 'cat_patenteaduanal', 'cat_origeninventario', 'cat_paises', 'cat_numpedimentoaduana', 'cat_municipios', 'ingreso', 'detalle_ingreso', 'emp_kilatajes', 'cat_monedas', 'cat_metododepago', 'cat_impuestos', 'status', 'menus', 'menuopciones', 'perfiles', 'tiposdedocumentos', 'venta', 'detalle_venta'];

            if (!$mainDb) {
                $this->error('❌ Debes especificar la base de datos principal con --db');
                return;
            }

            try {
                $pdo = new \PDO("mysql:host=$host;port={$this->option('port')};dbname=$mainDb", $user, $pass);
                $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

                $stmt = $pdo->query("SELECT DISTINCT idempresa FROM users");
                $empresasIds = $stmt->fetchAll(\PDO::FETCH_COLUMN);

                foreach ($empresasIds as $empresaId) {
                    $tenantDb = env('DB_TENANT_PREFIX', 'tenant_') . "{$empresaId}";
                    $this->info("🛠 Utilizando base de datos $tenantDb...");

                    $pdo->exec("SET SESSION sql_mode='NO_ENGINE_SUBSTITUTION'");

                    // Optimización de configuración para grandes volúmenes de datos

                    $pdo->exec('SET GLOBAL innodb_buffer_pool_size=268435456;');
                    // IMPORTANTE: La linea anterior puede requerir permisos de SUPERUSER.
                    // En caso de no tener permisos, comentar la línea anterior y descomentar las siguientes líneas de configuración de sesión.
                    // $pdo->exec("SET SESSION sql_mode='NO_ENGINE_SUBSTITUTION'");
                    // $pdo->exec('SET SESSION bulk_insert_buffer_size = 268435456');
                    // $pdo->exec('SET SESSION read_buffer_size = 8388608');
                    // $pdo->exec('SET SESSION read_rnd_buffer_size = 8388608');
                    // $pdo->exec('SET SESSION sort_buffer_size = 16777216');

                    foreach (array_merge($generalTables, $tables) as $table) {
                        if (!$copyStructure) {
                            break;
                        }
                        $this->info("📋 Copiando estructura de $table...");
                        $pdo->exec("DROP TABLE IF EXISTS `$tenantDb`.`$table`");
                        $createStmt = $pdo->query("SHOW CREATE TABLE `$table`")->fetch(\PDO::FETCH_ASSOC);
                        $createSQL = str_replace("CREATE TABLE `$table`", "CREATE TABLE `$tenantDb`.`$table`", $createStmt['Create Table']);
                        $pdo->exec($createSQL);

                        if ($table === 'usuarios_nube_escritorio') {
                            $this->info("📋 Copiando estructura de usuarios a $table...");
                            $pdo->exec("ALTER TABLE `$tenantDb`.`$table` CHANGE COLUMN `id_user` `id_central_user` BIGINT NOT NULL");
                        }
                    }
                    foreach ($generalTables as $generalTable) {
                        $this->info("📥 Insertando datos generales en $tenantDb.$generalTable para idempresa=$empresaId...");
                        $columnsStmt = $pdo->query("SHOW COLUMNS FROM `$tenantDb`.`$table`");
                        $columns =  $columnsStmt->fetchAll(\PDO::FETCH_COLUMN);
                        $columnsList = implode('`,`', $columns);
                        $values = $columnsList;
                        $pdo->exec("
                                    INSERT INTO `$tenantDb`.`$table` (`$columnsList`)
                                    SELECT `$values`
                                    FROM `$mainDb`.`$table`
                                ");
                    }

                    foreach ($tables as $table) {
                        if ($copyStructure) {
                            $pdo->exec("ALTER TABLE `$tenantDb`.`$table` DROP COLUMN idempresa");
                        }
                        $this->info("📥 Insertando datos en $tenantDb.$table para idempresa=$empresaId...");
                        $columnsStmt = $pdo->query("SHOW COLUMNS FROM `$tenantDb`.`$table`");
                        $columns =  $columnsStmt->fetchAll(\PDO::FETCH_COLUMN);
                        $columnsList = implode('`,`', $columns);
                        $values = $columnsList;
                        if ($table === 'usuarios_nube_escritorio') {
                            $values = str_replace('id_central_user', 'id_users` as `id_central_user', $columnsList);
                        }

                        if ($table === 'cat_conceptosinventarios') {
                            $pdo->exec("
                            INSERT INTO `$tenantDb`.`$table`
                            SELECT `$values`
                            FROM `$mainDb`.`$table`
                            WHERE idempresa = $empresaId
                            OR idempresa = 0
                            ");
                        } else {
                            $pdo->exec("
                                    INSERT INTO `$tenantDb`.`$table` (`$columnsList`)
                                    SELECT `$values`
                                    FROM `$mainDb`.`$table`
                                    WHERE idempresa = $empresaId
                                ");
                        }
                    }


                    $this->info("✅ Base de datos $tenantDb creada con éxito.");
                    $pdo->exec("USE `$mainDb`");
                }

                $this->info("🎉 Proceso finalizado.");
            } catch (\PDOException $e) {
                $this->error("❌ Error: " . $e->getMessage());
            }
        }
    }
}
