# Enkelt - Web

Para inicializar el proyecto, se deben seguir los siguientes pasos:

```bash
#Variables de entorno local
cp .env.example .env

#Instalar dependencias
composer install

#Generar la llave de laravel
php artisan key:generate

#Ejecutar migraciones
php artisan migrate

#Ejecutar el proyecto
php artisan serve
```

## Separación de empresas
Migración del modelo anterior de Mapro Web (single-tenancy) a multi-tenancy. Para soportar la nueva arquitectura consulte: [Guía separación de empresas](SepararEmpresas.md)

## Frontend

Para tener un entorno de desarrollo en local para el front-end es necesario tener cargados lo estilos a través de:
```bash
#Windows
npm run dev

#Unix (linux/macOS/etc)
sudo npm run dev #Como prefijo el comando correspondiente para el acceso Admin en el SO
```

## Api
Para acceder a los recursos protegidos de la API se necesita un JWT. Para crear y validar un JWT se necesita una llave secreta que se obtiene mediante una variable de entorno **JWT_SECRET**. Para generar una llave secreta genérica para un uso en depuración se puede ejecutar el siguiente comando en la raíz del proyecto:

```bash
php artisan jwt:secret
```
## Docker

Se debe construir e iniciar los contenedores definidos en [Dockerfile](Dockerfile) y [docker-compose.yml](./docker-compose.yml) con el siguiente comando: 
```bash
docker-compose up -d
```

Una vez que los contenedores esten en ejecución, se deben realizar los siguientes pasos:

### 1. Configuración de la aplicación
```bash
# Entrar al contenedor
docker-compose exec app bash

# Dentro del contenedor:
cp .env.example .env
composer install
php artisan key:generate
php artisan storage:link
php artisan migrate
```

### 2. Instalación de dependencias frontend
```bash
# Instalar dependencias Node.js (desde el contenedor o localmente)
npm install
npm run dev
```

### 3. Configuración de permisos

```bash
# En el contenedor
chown -R www-data:www-data storage bootstrap/cache
chmod -R 775 storage bootstrap/cache
```

